<?php

App::uses('BuzzVouchersAppModel', 'BuzzVouchers.Model');

class GiftVoucherPurchaseItem extends BuzzVouchersAppModel {

	/**
	 * Belongs to associations
	 *
	 * @var array
	 */
	public $belongsTo = array(
		'GiftVoucher' => array(
			'className' => 'BuzzVouchers.GiftVoucher'
		)
	);

	/**
	 * Has many associations
	 *
	 * @var array
	 */
	public $hasMany = array(
		'GiftVoucherPurchaseItemVoucher' => array(
			'className' => 'BuzzVouchers.GiftVoucherPurchaseItemVoucher'
		)
	);

	/**
	 * Validation rules
	 *
	 * @var array
	 */
	public $validate = array(
		'quantity' => array(
			'max' => array(
				'rule' => array('range', -1, 51),
				'message' => 'No more than 50 vouchers can be purchased at once',
				'allowEmpty' => true
			)
		)
	);

}
