<?php
App::uses('CakeEventListener', 'Event');
App::uses('GiftVoucherPurchaseState', 'BuzzVouchers.Model');

class GiftVoucherPurchaseListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Model.GiftVoucherPurchase.completed' => 'confirmation'
		);
	}

	public function confirmation(CakeEvent $Event) {
		$purchase = ClassRegistry::init('BuzzVouchers.GiftVoucherPurchase')->getPurchase($Event->data['id']);
		if (! empty($purchase)
			&& (int)$purchase['GiftVoucherPurchase']['gift_voucher_purchase_state_id'] === GiftVoucherPurchaseState::COMPLETE
		) {
			// Send confirmation email
			$Controller = new Controller();
			$Controller->helpers = ['BuzzTranslate.I18n', 'BuzzPurchase.Purchase'];
			$View = new View($Controller);
			$View->set('data', $purchase);
			$details = $View->render('BuzzVouchers./GiftVoucherPurchases/email_basket', 'ajax');

			$Email = ClassRegistry::init('BuzzEmails.Email');
			$email = ClassRegistry::init('BuzzEmails.Email')->generateEmailData(
				'BuzzVouchers.confirmation_email',
				[
					'salesRef' => $purchase['GiftVoucherPurchase']['sales_ref'],
					'details' => $details,
					'fullName' => $purchase['CustomerAddress']['first_name'] . ' ' . $purchase['CustomerAddress']['last_name'],
					'firstName' => $purchase['CustomerAddress']['first_name'],
					'lastName' => $purchase['CustomerAddress']['last_name']
				]
			);

			if (! empty($email)) {
				$Email->queueEmail(
					$email['Email']['subject'],
					$email['Email']['content'],
					array($purchase['CustomerAddress']['email'] => $purchase['CustomerAddress']['first_name'] . ' ' . $purchase['CustomerAddress']['last_name']),
					$email['Email']['from']
				);
			}
		}

		return;
	}

}
