<?php

App::uses('BuzzBookingsAppController', 'BuzzBookings.Controller');

class VoucherActivitiesController extends BuzzBookingsAppController {

	public $components = array(
		'BuzzAdverts.Adverts',
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'name',
				'page_title',
				'content',
				'secondary_content'
			)
		)
	);

	public function __construct($request = null, $response = null) {
		$this->adminActions[] = 'admin_adverts';
		parent::__construct($request, $response);
	}

	public function admin_edit($id = null) {
		parent::admin_edit($id);
		$this->Translation->adminTranslationFormFields();
		$this->Adverts->setupAdvertAdminFields();
		return;
	}

	/**
	 * Populate admin lookups
	 *
	 * @return void
	 */
	protected function _adminPopulateLookups() {
		$Activity = $this->{$this->modelClass};

		if (CakePlugin::loaded('BuzzGallery') === true) {
			$this->set('galleries', $Activity->Gallery->find('list'));
		}

		return;
	}

	/**
	 * Admin form fields
	 *
	 * @return array
	 */
	protected function _adminFormFields() {
		$VoucherActivity = $this->{$this->modelClass};
		$fields = parent::_adminFormFields();

		$fields['VoucherActivity.name']['after'] = '<p class="input__help">' . __d('buzz_bookings', 'The name of the activity used for the booking process.') . '</p>';

		$fields['VoucherActivity.page_title']['after'] = '<p class="input__help">' . __d('buzz_bookings', 'This is the title that appears at the top of the activity\'s page. Leave it blank to use the Activity name instead.') . '</p>';

		$fields['VoucherActivity.content']['type'] = 'html';
		$fields['VoucherActivity.secondary_content']['type'] = 'html';

		$fields['VoucherActivity.video_url']['label'] = __d('buzz_bookings', 'Video URL');

		return $fields;
	}

	protected function _adminFormToolbar($id = null) {
		$toolbar = parent::_adminFormToolbar($id);

		if (!empty($id)) {
			$toolbar['Adverts'] = [
				'url' => ['action' => 'adverts', $id],
				'icon' => 'bars'
			];
			$toolbar['Preview'] = [
				'url' => ['controller' => 'gift_voucher_purchases', 'action' => 'vouchers', $id, 'admin' => false],
				'icon' => 'search',
				'target' => '_blank'
			];
		}

		return $toolbar;
	}

}
