<?php
class AddedNewDiscountFieldsToGiftVoucherPurchaseItems extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'added_new_discount_fields_to_gift_voucher_purchase_items';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'gift_voucher_purchase_items' => array(
					'sales_ref' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8', 'after' => 'gift_voucher_purchase_id'),
					'discount' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false, 'after' => 'total'),
					'discount_code' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8_unicode_ci', 'comment' => 'V', 'charset' => 'utf8', 'after' => 'discount'),
					'discount_type' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 50, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8', 'after' => 'discount_code'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'gift_voucher_purchase_items' => array('sales_ref', 'discount', 'discount_code', 'discount_type'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
