<?php
class BuzzVouchersInitialMigration extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzVouchers_initial_migration';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'gift_voucher_delivery_options' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'description' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false),
					'sequence' => array('type' => 'integer', 'null' => false, 'default' => '0', 'unsigned' => false),
					'online' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
					'is_active' => array('type' => 'boolean', 'null' => false, 'default' => '1'),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci', 'engine' => 'InnoDB'),
				),
				'gift_voucher_purchase_items' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'gift_voucher_purchase_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'index'),
					'gift_voucher_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'index'),
					'quantity' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'item_unit_cost' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false),
					'total' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
						'fk_gift_voucher_purchase_items_gift_voucher_purchases1' => array('column' => 'gift_voucher_purchase_id', 'unique' => 0),
						'fk_gift_voucher_purchase_items_gift_vouchers1' => array('column' => 'gift_voucher_id', 'unique' => 0),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci', 'engine' => 'InnoDB'),
				),
				'gift_voucher_purchase_states' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci', 'engine' => 'InnoDB'),
				),
				'gift_voucher_purchases' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'sales_ref' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'customer_address_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'delivery_address_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'gift_voucher_delivery_option_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'gift_message' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 150, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'subtotal' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false),
					'delivery_cost' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false),
					'total_cost' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false),
					'gift_voucher_purchase_state_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'index'),
					'is_removed' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'completed_date' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
						'fk_gift_voucher_purchases_gift_voucher_purchase_states1' => array('column' => 'gift_voucher_purchase_state_id', 'unique' => 0),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci', 'engine' => 'InnoDB'),
				),
				'gift_vouchers' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 150, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'voucher_activity_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'index'),
					'description' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false),
					'is_special_offer' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
					'original_price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false),
					'participants' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'sequence' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'api_reference' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'is_active' => array('type' => 'boolean', 'null' => false, 'default' => '1'),
					'is_removed' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
						'fk_gift_vouchers_voucher_activities1' => array('column' => 'voucher_activity_id', 'unique' => 0),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci', 'engine' => 'InnoDB'),
				),
				'voucher_activities' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 150, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'listed' => array('type' => 'boolean', 'null' => false, 'default' => '1'),
					'sequence' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'is_active' => array('type' => 'boolean', 'null' => false, 'default' => '1'),
					'is_removed' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci', 'engine' => 'InnoDB'),
				),
			),
		),
		'down' => array(
			'drop_table' => array(
				'gift_voucher_delivery_options', 'gift_voucher_purchase_items', 'gift_voucher_purchase_states', 'gift_voucher_purchases', 'gift_vouchers', 'voucher_activities'
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$data = array(
				array(
					'id' => 1,
					'name' => 'Unpaid'
				),
				array(
					'id' => 2,
					'name' => 'Complete'
				),
				array(
					'id' => 3,
					'name' => 'Payment Failed'
				),
				array(
					'id' => 4,
					'name' => 'API Failed'
				),
			);
			ClassRegistry::init('BuzzVouchers.GiftVoucherPurchaseState')->saveMany($data);
		}
		return true;
	}
}
