<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_vouchers', '%s Voucher Step %d', [$this->I18n->translate($data, 'VoucherActivity.name'), 1]));
?>

<?php echo $this->Form->create(); ?>

<div class="basket" data-items="<?php echo !empty($basket['GiftVoucherPurchaseItem']) ? count($basket['GiftVoucherPurchaseItem']) : 0; ?>"></div>

<div class="row">
	<div class="col-xs-12">

		<h2><?php echo __d('buzz_vouchers', 'Select vouchers to purchase'); ?></h2>

		<?php foreach ($data['GiftVoucher'] as $voucher): ?>

			<?php echo $this->element('BuzzVouchers.Forms/voucher', ['data' => $voucher]); ?>

		<?php endforeach; ?>
	</div>
</div>

<div class="booking__actions">
	<div class="row">
		<div class="col-xs-6">
			<?php echo $this->Html->link(__d('buzz_vouchers', 'Back'), $previousStep, ['class' => 'button button--light background--septenary left button--booking-proceed']); ?>
		</div>

		<div class="col-xs-6">
			<?php echo $this->Form->button(__d('buzz_vouchers', 'Proceed'), ['class' => 'button button--dark background--senary right']); ?>
		</div>
	</div>
</div>

<?php echo $this->Form->end(); ?>
