<?php

$model = 'CustomerAddress.' . $key;

$flagErrors = !empty($this->request->data['GiftVoucherPurchase']['gift_voucher_delivery_option_id'])
	&& $this->request->data['GiftVoucherPurchase']['gift_voucher_delivery_option_id'] === $key;

echo $this->Form->input(
	$model . '.id'
);

$div = ['input text'];
if ($flagErrors === true && $this->Form->isFieldError('DeliveryAddress.first_name') === true) {
	$div[] = 'error';
}
$class = $flagErrors === true && $this->Form->isFieldError('DeliveryAddress.first_name') ? 'form-error' : null;
echo $this->Form->input(
	$model . '.first_name',
	[
		'label' => __d('buzz_vouchers', 'First name'),
		'class' => $class,
		'div' => implode(' ', $div),
		'after' => $flagErrors ? $this->Form->error('DeliveryAddress.first_name') : null
	]
);

$div = ['input text'];
if ($flagErrors === true && $this->Form->isFieldError('DeliveryAddress.last_name') === true) {
	$div[] = 'error';
}
$class = $flagErrors === true && $this->Form->isFieldError('DeliveryAddress.last_name') ? 'form-error' : null;
echo $this->Form->input(
	$model . '.last_name',
	[
		'label' => __d('buzz_vouchers', 'Last name'),
		'class' => $class,
		'div' => implode(' ', $div),
		'after' => $flagErrors ? $this->Form->error('DeliveryAddress.last_name') : null
	]
);

$div = ['input text'];
if ($flagErrors === true && $this->Form->isFieldError('DeliveryAddress.address_line_1') === true) {
	$div[] = 'error';
}
$class = $flagErrors === true && $this->Form->isFieldError('DeliveryAddress.address_line_1') ? 'form-error' : null;
echo $this->Form->input(
	$model . '.address_line_1',
	[
		'label' => __d('buzz_vouchers', 'Address'),
		'class' => $class,
		'div' => implode(' ', $div),
		'after' => $flagErrors ? $this->Form->error('DeliveryAddress.address_line_1') : null
	]
);

$div = ['input input--displace-label'];
if ($flagErrors === true && $this->Form->isFieldError('DeliveryAddress.address_line_2') === true) {
	$div[] = 'error';
}
$class = $flagErrors === true && $this->Form->isFieldError('DeliveryAddress.address_line_2') ? 'form-error' : null;
echo $this->Form->input(
	$model . '.address_line_2',
	[
		'label' => __d('buzz_vouchers', 'Address Line 2'),
		'class' => $class,
		'div' => implode(' ', $div),
		'after' => $flagErrors ? $this->Form->error('DeliveryAddress.address_line_2') : null
	]
);

$div = ['input text'];
if ($flagErrors === true && $this->Form->isFieldError('DeliveryAddress.city') === true) {
	$div[] = 'error';
}
$class = $flagErrors === true && $this->Form->isFieldError('DeliveryAddress.city') ? 'form-error' : null;
echo $this->Form->input(
	$model . '.city',
	[
		'label' => __d('buzz_vouchers', 'Town/City'),
		'class' => $class,
		'div' => implode(' ', $div),
		'after' => $flagErrors ? $this->Form->error('DeliveryAddress.city') : null
	]
);

if (empty($restrictToCountry)) {
	$div = ['input select js-country'];
	if ($flagErrors === true && $this->Form->isFieldError('DeliveryAddress.country_id') === true) {
		$div[] = 'error';
	}
	$class = $flagErrors === true && $this->Form->isFieldError('DeliveryAddress.country_id') ? 'form-error' : null;
	echo $this->Form->input(
		$model . '.country_id',
		[
			'label' => __d('buzz_vouchers', 'Country'),
			'class' => $class,
			'div' => implode(' ', $div),
			'after' => $flagErrors ? $this->Form->error('DeliveryAddress.country_id') : null
		]
	);
} else {
	echo '<div class="js-country">';
	echo $this->Form->input(
		$model . '.country_id',
		['value' => $restrictToCountry, 'type' => 'hidden']
	);
	echo '</div>';
	echo '<div class="field input">';
	echo $this->Html->tag(
		'div',
		$this->Form->label($model . '.country_id', __d('buzz_vouchers', 'Country')),
		['class' => 'field__label']
	);
	echo $this->Html->tag(
		'div',
		$countries[$restrictToCountry]
	);
	echo '</div>';
}

if (empty($restrictToCountry) || (int)$restrictToCountry === 226) {
	$div = ['input select js-us-state'];
	if ($flagErrors === true && $this->Form->isFieldError('DeliveryAddress.us_state_id') === true) {
		$div[] = 'error';
	}
	$class = $flagErrors === true && $this->Form->isFieldError('DeliveryAddress.us_state_id') ? 'form-error' : null;
	echo $this->Form->input(
		$model . '.us_state_id',
		[
			'label' => __d('buzz_vouchers', 'State'),
			'class' => $class,
			'div' => implode(' ', $div),
			'after' => $flagErrors ? $this->Form->error('DeliveryAddress.us_state_id') : null
		]
	);
}

$div = ['input text js-postcode'];
if ($flagErrors === true && $this->Form->isFieldError('DeliveryAddress.postcode') === true) {
	$div[] = 'error';
}
$class = $flagErrors === true && $this->Form->isFieldError('DeliveryAddress.postcode') ? 'form-error' : null;
echo $this->Form->input(
	$model . '.postcode',
	[
		'label' => __d('buzz_vouchers', 'Postcode'),
		'class' => $class,
		'div' => implode(' ', $div),
		'class' => 'text-uppercase',
		'after' => $flagErrors ? $this->Form->error('DeliveryAddress.postcode') : null,
		'required' => false
	]
);
