<?php

class GiftVoucherPurchaseTest extends CakeTestCase {

	public $fixtures = array(
		'plugin.buzz_vouchers.GiftVoucherPurchase',
		'plugin.buzz_vouchers.GiftVoucherPurchaseItem',
		'plugin.buzz_vouchers.GiftVoucher',
		'plugin.buzz_vouchers.GiftVoucherDeliveryOption',
		'plugin.buzz_vouchers.VoucherActivity',
		'plugin.buzz_customers.CustomerAddress',
		'plugin.buzz_customers.Country',
		'plugin.buzz_customers.UsState',
		'plugin.buzz_translate.Translation'
	);

	public function setUp() {
		parent::setUp();
		$this->GiftVoucherPurchase = ClassRegistry::init('BuzzVouchers.GiftVoucherPurchase');
	}

/**
 * Make protected methods accessible for testing
 *
 * @param string $name Method name
 * @return object
 */
	public static function getMethod($name) {
		$GiftVoucherPurchase = new ReflectionClass('GiftVoucherPurchase');
		$method = $GiftVoucherPurchase->getMethod($name);
		$method->setAccessible(true);
		return $method;
	}

	public function testGetBasket() {
		// Test that we can retrieve a basket.
		$GiftVoucherPurchase = $this->getMockForModel('GiftVoucherPurchase', ['getBasketId']);
		$GiftVoucherPurchase->expects($this->any())->method('getBasketId')->will($this->returnValue(1));
		$result = $GiftVoucherPurchase->getBasket();
		$this->assertEquals(1, $result['GiftVoucherPurchase']['id']);
		return;
	}

	public function testGetBasketFails() {
		$GiftVoucherPurchase = $this->getMockForModel('GiftVoucherPurchase', ['getBasketId']);
		$GiftVoucherPurchase->expects($this->any())->method('getBasketId')->will($this->returnValue(2));
		$result = $GiftVoucherPurchase->getBasket();
		$this->assertEquals([], $result);
		return;
	}

/**
 * Test adding items to a new basket
 *
 * @return void
 */
	public function testAddItemsToNewBasket() {
		$GiftVoucherPurchase = $this->getMockForModel('GiftVoucherPurchase', ['getBasketId']);
		// Mock the getBasketId method so that it correctly returns the basket
		// ID after the basket is created by the test.
		$GiftVoucherPurchase->expects($this->any())->method('getBasketId')->will($this->onConsecutiveCalls(null, 2));
		$result = $GiftVoucherPurchase->addItems(
			array(
				array(
					'id' => null,
					'gift_voucher_id' => 1,
					'quantity' => 1
				),
				array(
					'id' => null,
					'gift_voucher_id' => 2,
					'quantity' => 2
				)
			)
		);
		$this->assertTrue($result);
		// Make sure the items have been created.
		$result = $GiftVoucherPurchase->GiftVoucherPurchaseItem->find(
			'all',
			array(
				'conditions' => array(
					'GiftVoucherPurchaseItem.gift_voucher_purchase_id' => $GiftVoucherPurchase->id
				)
			)
		);
		$this->assertCount(2, $result);
		// Check that the items are being summed correctly
		$this->assertEquals(30, $result[1]['GiftVoucherPurchaseItem']['total']);

		return;
	}

/**
 * Test removing items from an existing basket
 *
 * @return void
 */
	public function testAddItemsRemoveItem() {
		$GiftVoucherPurchase = $this->getMockForModel('GiftVoucherPurchase', ['getBasketId']);
		$GiftVoucherPurchase->expects($this->any())->method('getBasketId')->will($this->returnValue(1));
		$result = $GiftVoucherPurchase->addItems(
			array(
				array(
					'id' => 1,
					'gift_voucher_id' => 1,
					'quantity' => 1
				),
				array(
					'id' => 2,
					'gift_voucher_id' => 2,
					'quantity' => 0
				)
			)
		);
		$this->assertTrue($result);
		// Make sure the items have been updated.
		$result = $GiftVoucherPurchase->GiftVoucherPurchaseItem->find(
			'all',
			array(
				'conditions' => array(
					'GiftVoucherPurchaseItem.gift_voucher_purchase_id' => 1
				)
			)
		);
		$this->assertCount(1, $result);
		// Check that the items are being summed correctly
		$this->assertEquals(1, $result[0]['GiftVoucherPurchaseItem']['quantity']);

		return;
	}

/**
 * Test updating basket
 *
 * @return void
 */
	public function testUpdateItems() {
		$GiftVoucherPurchase = $this->getMockForModel('GiftVoucherPurchase', ['getBasketId']);
		$GiftVoucherPurchase->expects($this->any())->method('getBasketId')->will($this->returnValue(1));
		$result = $GiftVoucherPurchase->updateItems(
			array(
				// Increase item
				1 => array(
					'id' => 1,
					'quantity' => 3
				),
				// Remove item
				2 => array(
					'id' => 2,
					'quantity' => 0
				)
			)
		);
		$this->assertTrue($result);
		// Make sure the items have been updated.
		$result = $GiftVoucherPurchase->GiftVoucherPurchaseItem->find(
			'all',
			array(
				'conditions' => array(
					'GiftVoucherPurchaseItem.gift_voucher_purchase_id' => 1
				)
			)
		);
		$this->assertCount(1, $result);
		// Check that the items are being summed correctly
		$this->assertEquals(3, $result[0]['GiftVoucherPurchaseItem']['quantity']);

		return;
	}

/**
 * Test removing an item from the basket
 *
 * @return void
 */
	public function testRemoveItem() {
		$GiftVoucherPurchase = $this->getMockForModel('GiftVoucherPurchase', ['getBasketId']);
		$GiftVoucherPurchase->expects($this->any())->method('getBasketId')->will($this->returnValue(1));
		$result = $GiftVoucherPurchase->removeItem(1);
		$this->assertTrue($result);
		// Make sure the items have been updated.
		$result = $GiftVoucherPurchase->GiftVoucherPurchaseItem->find(
			'all',
			array(
				'conditions' => array(
					'GiftVoucherPurchaseItem.gift_voucher_purchase_id' => 1
				)
			)
		);
		$this->assertCount(1, $result);
		// Check that the correct item is still in the basket.
		$this->assertEquals(2, $result[0]['GiftVoucherPurchaseItem']['gift_voucher_id']);

		return;
	}

/**
 * Test the update basket total method.
 *
 * @return void
 */
	public function testUpdateBasketTotal() {
		$GiftVoucherPurchase = $this->getMockForModel('GiftVoucherPurchase', ['getBasketId']);
		$GiftVoucherPurchase->expects($this->any())->method('getBasketId')->will($this->returnValue(1));
		$updateBasketTotal = self::getMethod('_updateBasketTotal');
		$result = $updateBasketTotal->invokeArgs($GiftVoucherPurchase, []);
		$this->assertTrue($result);

		$result = $GiftVoucherPurchase->findById(1);
		$this->assertEquals(65, $result['GiftVoucherPurchase']['total_cost']);

		return;
	}

	public function testAddDeliveryDetails() {
		$GiftVoucherPurchase = $this->getMockForModel('GiftVoucherPurchase', ['getBasketId']);
		$GiftVoucherPurchase->expects($this->any())->method('getBasketId')->will($this->returnValue(1));
		$result = $GiftVoucherPurchase->addDeliveryDetails(
			2,
			array(
				'first_name' => 'Joe',
				'last_name' => 'Bloggs',
				'address_line_1' => 'Evoluted',
				'city' => 'Sheffield',
				'postcode' => 'S3 7BH',
				'country_id' => 225,
				'us_state_id' => null,
				'telephone' => '+114 272 9753',
				'email' => 'info@evoluted.net'
			)
		);
		$this->assertTrue($result);

		$result = $GiftVoucherPurchase->addDeliveryDetails(
			1,
			[],
			'Test message'
		);
		$this->assertTrue($result);

		return;
	}

	public function testAddBillingDetails() {
		$GiftVoucherPurchase = $this->getMockForModel('GiftVoucherPurchase', ['getBasketId']);
		$GiftVoucherPurchase->expects($this->any())->method('getBasketId')->will($this->returnValue(1));
		$result = $GiftVoucherPurchase->addBillingDetails(
			array(
				'first_name' => 'Joe',
				'last_name' => 'Bloggs',
				'address_line_1' => 'Evoluted',
				'city' => 'Sheffield',
				'postcode' => 'S3 7BH',
				'country_id' => 225,
				'us_state_id' => null,
				'telephone' => '+114 272 9753',
				'email' => 'info@evoluted.net'
			)
		);
		$this->assertTrue($result);

		$result = $GiftVoucherPurchase->addBillingDetails(
			array(
				'first_name' => 'Joe',
				'last_name' => 'Bloggs',
				'address_line_1' => 'Evoluted',
				'city' => 'Sheffield',
				'postcode' => 'S3 7BH',
				'country_id' => 226,
				'us_state_id' => null,
				'telephone' => '+114 272 9753',
				'email' => 'info@evoluted.net'
			)
		);
		$this->assertFalse($result);

		return;
	}

	public function testHashBasketId() {
		$result = $this->GiftVoucherPurchase->hashBasketId(1);
		$this->assertEquals('c4ca4238a0b923820dcc509a6f75849b', $result);

		return;
	}

}
