<?php

App::uses('BuzzSourceAppModel', 'BuzzSource.Model');

class VoucherApi extends BuzzSourceAppModel {

	/**
	 * Create a gift voucher.
	 *
	 * @param string $model Calling model for logging API call
	 * @param int $foreignId
	 * @param string $firstName
	 * @param string $lastName
	 * @param string $email
	 * @param string $telephone
	 * @param array $address Address generated by CustomerAddress::generateAddressArray()
	 * @param string $message Gift message
	 * @param string $templateId Voucher template
	 * @param int $quantity Quantity of vouchers being purchased
	 * @param bool $isEvoucher True if an e-voucher
	 * @param string $ip IP address
	 * @param array $payment Payment details for the API
	 * @param float $total Amount paid
	 * @param int $salesOrderId Sales Order ID (from the API)
	 * @return array|bool
	 */
	public function createVoucher($model, $foreignId, $firstName, $lastName, $email, $telephone, $address, $message, $templateId, $quantity, $isEvoucher, $ip, array $payment, $total = 0, $salesOrderId = null) {
		$result = $this->find('all', [
			'method' => 'CreateVoucher',
			'conditions' => [
				'firstname' => $firstName,
				'lastname' => $lastName,
				'email' => $email,
				'telephone' => $telephone,
				'addressline1' => $address['address_line_1'],
				'addressline2' => $address['address_line_2'],
				'addressline3' => $address['address_line_3'],
				'addressline4' => $address['address_line_4'],
				'postcode' => $address['postcode'],
				'message' => $message,
				'templateId' => $templateId,
				'quantity' => (int)$quantity,
				'isevoucher' => $isEvoucher === true ? 'true' : 'false',
				'ipaddress' => $ip === null ? $_SERVER['REMOTE_ADDR'] : $ip,
				'vendortxcode' => $payment['vendorTxCode'],
				'vpstxId' => $payment['vpstxId'],
				'status' => $payment['status'],
				'txauthno' => $payment['txauthno'],
				'totalPaid' => $total,
				'salesorderId' => $salesOrderId ?: 0
			],
			'apiLog' => [
				'model' => $model,
				'foreign_id' => $foreignId
			]
		]);

		return !empty($result['VoucherApi']['d']) ? $this->_processVouchers($result['VoucherApi']['d']) : false;
	}

/**
 * Process gift vouchers data from the API
 *
 * @param array $data Response from API
 * @return array|bool Returns false if something is wrong
 */
	protected function _processVouchers($data) {
		$result = [];

		foreach ($data as $voucher) {
			if (empty($voucher['VoucherNo']) || empty($voucher['ExpiryDate'])) {
				return false;
			}
			$result['Voucher'][] = array(
				'id' => $voucher['Id'],
				'description' => $voucher['Description'],
				'code' => $voucher['VoucherNo'],
				'expiry_date' => $voucher['ExpiryDate'],
				'sales_order_id' => $voucher['SalesOrderId']
			);
		}

		return $result;
	}

}
