<?php

App::uses('BuzzVouchersAppModel', 'BuzzVouchers.Model');

class GiftVoucherPurchaseItemVoucher extends BuzzVouchersAppModel {

/**
 * Belongs to associations
 *
 * @var array
 */
	public $belongsTo = array(
		'GiftVoucherPurchaseItem' => array(
			'className' => 'BuzzVouchers.GiftVoucherPurchaseItem'
		)
	);

/**
 * Returns a gift voucher
 *
 * @param int $id Record ID
 * @param int $giftVoucherPurchaseId Gift voucher purchase ID
 * @param string $code Voucher code
 * @return array|bool
 */
	public function getVoucher($id, $giftVoucherPurchaseId, $code) {
		$conditions = array(
			'GiftVoucherPurchaseItemVoucher.id' => $id,
			'GiftVoucherPurchaseItemVoucher.code' => $code,
			'GiftVoucherPurchaseItem.gift_voucher_purchase_id' => $giftVoucherPurchaseId,
		);
		$contain = ['GiftVoucherPurchaseItem'];
		return $this->find('first', compact('contain', 'conditions')) ?: false;
	}

}
