<?php

App::uses('BuzzVouchersAppModel', 'BuzzVouchers.Model');

class GiftVoucherDeliveryOption extends BuzzVouchersAppModel {

	/**
	 * Belongs to associations
	 *
	 * @var array
	 */
	public $belongsTo = array(
		'Country' => array(
			'className' => 'BuzzCustomers.Country'
		)
	);

	/**
	 * Behaviors
	 *
	 * @var array
	 */
	public $actsAs = array(
		'BuzzTranslate.Translatable'
	);

	/**
	 * Validation rules
	 *
	 * @var array
	 */
	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters'
			)
		),
		'price' => array(
			'required' => array(
				'rule' => '/^\d+(\.\d{2})?$/',
				'message' => 'Required'
			)
		)
	);

	/**
	 * Image slots
	 *
	 * @var array
	 */
	public $imageSlots = [
		'main' => [
			'slots' => 1,
			'fields' => []
		]
	];

	public function getOptions() {
		$contain = ['Image'];
		$conditions = [
			'GiftVoucherDeliveryOption.is_active' => true
		];
		$order = 'GiftVoucherDeliveryOption.sequence ASC';
		return $this->find('all', compact('contain', 'conditions', 'order'));
	}

}
