<?php

App::uses('BuzzVouchersAppModel', 'BuzzVouchers.Model');

class GiftVoucher extends BuzzVouchersAppModel {

/**
 * Behaviors
 *
 * @var array
 */
	public $actsAs = array(
		'BuzzTranslate.Translatable',
	);

/**
 * Belongs to associations
 *
 * @var array
 */
	public $belongsTo = array(
		'VoucherActivity' => array(
			'className' => 'BuzzVouchers.VoucherActivity'
		)
	);

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('maxLength', 150),
				'message' => 'No more than 150 characters'
			)
		),
		'voucher_activity_id' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			)
		),
		'api_reference' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'code' => array(
				'rule' => '/^\d+$/',
				'message' => 'Invalid reference codes'
			)
		),
		'price' => array(
			'required' => array(
				'rule' => '/^\d+(\.\d{2})?$/',
				'message' => 'Required'
			)
		),
		'original_price' => array(
			'currency' => array(
				'rule' => '/^\d+(\.\d{2})?$/',
				'message' => 'Not a valid price',
				'allowEmpty' => true
			)
		),
		'participants' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'integer' => array(
				'rule' => array('naturalNumber', true)
			)
		),
	);

/**
 * Image slots
 *
 * @var array
 */
	public $imageSlots = [
		'main' => [
			'slots' => 1,
			'fields' => []
		]
	];

}
