<?php

App::uses('BuzzBookingsAppController', 'BuzzBookings.Controller');

class GiftVouchersController extends BuzzBookingsAppController {

	public $components = array(
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'name',
				'description'
			)
		)
	);

	public function admin_edit($id = null) {
		parent::admin_edit($id);
		$this->Translation->adminTranslationFormFields();
		return;
	}

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['GiftVoucher.participants']['type'] = 'select';

		$fields['GiftVoucher.use_all_discount_codes']['after'] = '<p class="input__help">' . __d('buzz_bookings', 'When ticked, any discount code can be used without restriction. Alternatively you can leave this unticked, and enter specific discount codes below.') . '</p>';

		$fields['GiftVoucher.valid_discount_codes']['type'] = 'string';
		$fields['GiftVoucher.valid_discount_codes']['after'] = '<p class="input__help">' . __d('buzz_bookings', 'Enter specific discount codes to allow, comma separated.') . '</p>';


		return $fields;
	}

/**
 * Populate admin lookups
 *
 * @return void
 */
	protected function _adminPopulateLookups() {
		$GiftVoucher = $this->{$this->modelClass};

		$this->set('voucherActivities', $GiftVoucher->VoucherActivity->find('list'));

		$participants = array_combine(range(1, 12), range(1, 12));
		array_unshift($participants, __d('buzz_vouchers', 'Private Hire'));
		$this->set(compact('participants'));

		return;
	}

/**
 * Admin index paginate
 *
 * @return array
 */
	protected function _adminIndexPaginate() {
		$conditions = $this->_processFilter();

		$paginate = array(
			'conditions' => $conditions,
			'contain' => array(
				'VoucherActivity'
			)
		);

		return $paginate;
	}

/**
 * Admin index columns
 *
 * @return array
 */
	protected function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();

		$newColumns = array(
			'VoucherActivity.name' => array(
				'label' => __d('buzz_vouchers', 'Activity'),
				'type' => 'string'
			)
		);

		return ArrayUtil::addAfter($columns, 'GiftVoucher.name', $newColumns);
	}

/**
 * Filters
 *
 * @return array
 */
	protected function _adminFilterFields() {
		$filters = parent::_adminFilterFields();

		$newFilters = array(
			'GiftVoucher.voucher_activity_id' => array(
				'label' => __d('buzz_vouchers', 'Activity'),
				'type' => 'select',
				'compare' => array('GiftVoucher.voucher_activity_id' => "%s")
			)
		);

		return ArrayUtil::addAfter($filters, 'GiftVoucher.name', $newFilters);
	}

}
