<?php

require_once '../../Vendor/setasign/fpdf/fpdf.php';
require_once '../../Vendor/setasign/fpdi/fpdi.php';

App::uses('BuzzVouchersAppController', 'BuzzVouchers.Controller');

class GiftVoucherPurchaseItemVouchersController extends BuzzVouchersAppController {

/**
 * Before filter
 *
 * @return void
 */
	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'evoucher'
		));

		return;
	}

/**
 * Generates a gift voucher
 *
 * @param int $id Record ID
 * @param int $giftVoucherPurchaseId Gift voucher purchase ID
 * @param string $code Voucher code
 * @return void
 */
	public function evoucher($id, $giftVoucherPurchaseId, $code) {
		$data = $this->GiftVoucherPurchaseItemVoucher->getVoucher($id, $giftVoucherPurchaseId, $code);

		if ($data !== false) {
			$this->_generateEvoucher($data);
		} else {
			throw new InternalErrorException();
		}

		return;
	}

/**
 * Generates a PDF evoucher
 *
 * @param array $data
 * @return void
 */
	protected function _generateEvoucher(array $data) {
		$Pdf =& new FPDI();

		$Pdf->AddPage();

		// Check if we have a translated voucher to use. Otherwise, fallback
		// to the default.
		if (
			Configure::check('Config.language') === true
			&& file_exists('voucher_templates' . DS . Configure::read('Config.language') . '.pdf') === true
		) {
			$voucher = Configure::read('Config.language') . '.pdf';
		} else {
			$voucher = 'default.pdf';
		}

		$Pdf->setSourceFile('voucher_templates/' . $voucher);

		// Import page 1
		$pdfTemplate = $Pdf->importPage(1);
		$Pdf->useTemplate($pdfTemplate, 0, 0, 0, 0, true);

		$Pdf->SetTextColor(0, 0, 0);
		$Pdf->SetFont('Arial', '', '10');
		$Pdf->Text(25, 50, utf8_decode(__d('buzz_vouchers', 'This voucher entitles the holder to:')));
		$Pdf->SetFont('Arial', 'B', '10');
		$Pdf->Text(25, 55, $data['GiftVoucherPurchaseItemVoucher']['description']);
		$Pdf->SetFont('Arial', '', '10');
		$Pdf->Text(25, 60, utf8_decode(__d('buzz_vouchers', 'Expires:')));
		$Pdf->SetFont('Arial', 'B', '10');
		$Pdf->Text(25, 65, $data['GiftVoucherPurchaseItemVoucher']['expiry_date']);
		$Pdf->SetFont('Arial', '', '10');
		$Pdf->Text(25, 70, utf8_decode(__d('buzz_vouchers', 'Voucher Number:')));
		$Pdf->SetFont('Arial', 'B', '10');
		$Pdf->Text(25, 75, $data['GiftVoucherPurchaseItemVoucher']['code']);

		$filename = 'evoucher-' . $data['GiftVoucherPurchaseItemVoucher']['code'] . '.pdf';

		// Generate the PDF.
		$Pdf->Output($filename, 'D');
		header('location: ' . $filename);

		return;
	}

}
