<?php

App::uses('BuzzBookingsAppController', 'BuzzBookings.Controller');

class GiftVoucherDeliveryOptionsController extends BuzzBookingsAppController {

	public $components = array(
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'name',
				'description'
			)
		)
	);

	public function admin_edit($id = null) {
		parent::admin_edit($id);
		$this->Translation->adminTranslationFormFields();
		return;
	}

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['GiftVoucherDeliveryOption.online']['label'] = __d('buzz_vouchers', 'Online Delivery');
		$fields['GiftVoucherDeliveryOption.country_id']['label'] = __d('buzz_vouchers', 'Restrict to Country');
		$fields['GiftVoucherDeliveryOption.country_id']['empty'] = __d('buzz_vouchers', 'Any');

		return $fields;
	}

	/**
	 * Admin index columns
	 *
	 * @return array
	 */
	protected function _adminIndexColumns() {
		$GiftVoucherDeliveryOption = $this->{$this->modelClass};

		$columns = parent::_adminIndexColumns();

		$columns[$GiftVoucherDeliveryOption->alias . '.price']['type'] = 'currency';

		return $columns;
	}

	/**
	 * Admin columns whitelist
	 *
	 * @return array
	 */
	protected function _adminIndexColumnsWhitelist() {
		$GiftVoucherDeliveryOption = $this->{$this->modelClass};

		$whitelist = parent::_adminIndexColumnsWhitelist();
		$whitelist[] = $GiftVoucherDeliveryOption->alias . '.price';

		return $whitelist;
	}

	protected function _adminPopulateLookups() {
		$GiftVoucherDeliveryOption = $this->{$this->modelClass};
		$this->set('countries', $GiftVoucherDeliveryOption->Country->find('list'));
		return;
	}

}
