<?php
class AddedDiscountFieldsToGiftVouchers extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'Added_discount_fields_to_gift_vouchers';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'gift_voucher_purchases' => array(
					'discount' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false, 'after' => 'delivery_cost'),
					'discount_code' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 100, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8', 'after' => 'discount'),
				),
				'gift_vouchers' => array(
					'use_all_discount_codes' => array('type' => 'boolean', 'null' => true, 'default' => null, 'after' => 'participants'),
					'valid_discount_codes' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8', 'after' => 'use_all_discount_codes'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'gift_voucher_purchases' => array('discount', 'discount_code'),
				'gift_vouchers' => array('use_all_discount_codes', 'valid_discount_codes'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
