<?php
App::uses('BuzzVideoPanelAppModel', 'BuzzVideoPanel.Model');

class VideoPanel extends BuzzVideoPanelAppModel {

	public $displayField = 'title';

/**
 * Behaviors
 *
 * @var array
 */
	public $actsAs = array(
		'BuzzTranslate.Translatable'
	);

	public $imageSlots = array(
		'background' => array(
			'fields' => false,
			'slots' => 1
		)
	);

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = [
		'title' => [
			'required' => [
				'rule' => 'notEmpty',
				'message' => 'Required'
			],
			'max' => [
				'rule' => ['maxLength', 45],
				'message' => 'No more than 45 characters'
			]
		],
		'video_url' => [
			'required' => [
				'rule' => 'url',
				'message' => 'Invalid URL'
			]
		],
		'link_url_1' => [
			'url' => [
				'rule' => 'validateUrls',
				'message' => 'Invalid URL',
				'allowEmpty' => true
			]
		],
		'link_url_2' => [
			'url' => [
				'rule' => 'validateUrls',
				'message' => 'Invalid URL',
				'allowEmpty' => true
			]
		],
		'sequence' => [
			'required' => [
				'rule' => 'notEmpty',
				'message' => 'Required'
			],
			'max' => [
				'rule' => ['naturalNumber', true]
			]
		],
	];

/**
 * Custom validation method for checking a URL (internal or external).
 *
 * @param array $data
 * @return bool
 */
	public function validateUrls(array $data) {
		$check = array_pop($data);

		$validates = preg_match('|^\/[\w\-_\/]+|', $check) === 1;
		if ($validates === false) {
			$validates = Validation::url($check);
		}

		return $validates;
	}

/**
 * Get video panels
 * @param int $limit Maximum number of panels to return
 * @return array Panels
 */
	public function getPanels($limit = 1) {
		return $this->find('all', [
			'contain' => 'BackgroundImage',
			'conditions' => [
				$this->escapeField('is_active') => true
			],
			'limit' => $limit,
			'order' => [
				$this->escapeField('modified') => 'DESC'
			]
		]);
	}

}
