<?php
App::uses('BuzzVideoPanelAppController', 'BuzzVideoPanel.Controller');

class VideoPanelsController extends BuzzVideoPanelAppController {

	public $components = array(
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'title',
				'content',
				'link_text_1',
				'link_text_2'
			)
		)
	);

/**
 * Admin add/edit
 * @param int $id Video panel ID
 * @return void
 */
	public function admin_edit($id = null) {
		parent::admin_edit($id);
		$this->Translation->adminTranslationFormFields();

		return;
	}

/**
 * Admin form fields
 *
 * @return array
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();
		$fields['VideoPanel.video_url']['label'] = 'Video URL';
		$fields['VideoPanel.video_url']['placeholder'] = 'Youtube / Vimeo URL';
		$fields['VideoPanel.link_url_1']['label'] = 'Link URL 1';
		$fields['VideoPanel.link_url_2']['label'] = 'Link URL 2';

		return $fields;
	}

}
