BuzzTranslate
=============

Plugin used by Twinwoods and associated sites for handling translations.

Usage
-----

To make a model's content translatable the `Translatable` behavior needs attaching:-

```
public $actsAs = [
	'BuzzTranslate.Translatable'
];
```

Then the controller that provides the admin interface for the model wants the `Translation` component. You need to pass the `fields` that want translations to the component and can define form field settings relevant to the field as you would for a normal form field:-

```
public $components = [
	'BuzzTranslate.Translation' => [
		'fields' => [
			'name',
			'content' => [
				'type' => 'html'
			]
		],
		'menu' => true,
		'meta' => true
	)
];
```

Pass flags for `menu` and `meta` to expose the menu and meta fields for translation.

To output a translated string use the `I18n` helper passing the data array and array path:-

```
<?= $this->I18n->translate($data, 'Activity.name') ?>
```

Notes
-----

The translatable behavior can only retrieve the translations for the primary model and its direct associations. So when retrieving data for deeper associations these need attaching after the initial query. This might seem strange, but it improves performance as we can reduce the number of queries to the translations table needed.