<?php
App::uses('Controller', 'Controller');
App::uses('View', 'View');
App::uses('HtmlHelper', 'View/Helper');
App::uses('I18nHelper', 'BuzzTranslate.View/Helper');

class I18nHelperTest extends CakeTestCase {

	public $I18n = null;

	public function setUp() {
		parent::setUp();
		$Controller = new Controller();
		$View = new View($Controller);
		$this->I18n = new I18nHelper($View);
	}

	public function testTranslate() {
		$data = array(
			'Page' => array(
				'title' => 'Hello World',
				'body' => 'Test',
				'__i18n' => array(
					'fre' => array(
						'content' => array(
							'title' => 'Bonjour le monde'
						)
					)
				)
			)
		);
		// Test text translates when translation is available.
		$result = $this->I18n->translate($data, 'Page.title', 'fre');
		$this->assertEquals('Bonjour le monde', $result);

		// Check fallback onto default language.
		$result = $this->I18n->translate($data, 'Page.body', 'fre');
		$this->assertEquals('Test', $result);

		return;
	}

}
