<?php

App::uses('BuzzTranslateAppModel', 'BuzzTranslate.Model');

class Translation extends BuzzTranslateAppModel {

/**
 * Returns the default locale for the app (default is English).
 *
 * @return string
 */
	public static function getDefaultLocale() {
		if (Configure::check('BuzzTranslate.default_locale')) {
			// Get the app's default locale.
			$locale = Configure::read('BuzzTranslate.default_locale');
		} else {
			// Default to English.
			$locale = 'eng';
		}
		return $locale;
	}

/**
 * Returns the available locales.
 *
 * @param bool $excludeDefault Pass true to exclude the default locale from the return
 * @return array
 */
	public static function getLocales($excludeDefault = false) {
		$locales = Configure::read('BuzzTranslate.locales');
		if ($excludeDefault === true) {
			$locales = Hash::remove($locales, '{s}[lang=' . static::getDefaultLocale() . ']');
		}
		return $locales;
	}

/**
 * Gets translations for specified model items.
 *
 * @param string $model
 * @param array $ids
 * @return array
 */
	public function getTranslations($model, $ids) {
		return $this->find(
			'all',
			array(
				'conditions' => array(
					$this->alias . '.model' => $model,
					$this->alias . '.foreign_id' => $ids
				)
			)
		);
	}

	public function afterFind($results, $primary = false) {
		foreach ($results as &$result) {
			$result[$this->alias]['content'] = json_decode($result[$this->alias]['content'], true);
		}
		return $results;
	}

}
