<?php


App::uses('Hash', 'Utility');

class TranslateUtil {

/**
 * Returns translated value if available.
 *
 * @param array
 * @param string $path Hash path syntax
 * @param string $locale
 * @return string
 */
	public static function translate(array $data, $path, $locale = null) {
		$locale = $locale?: Configure::read('Config.language');
		if (strpos($path, '.') === false) {
			$translationPath = '__i18n.' . $locale . '.content.' . $path;
		} else {
			$translationPath = preg_replace('|\.(\w+)$|', '.__i18n.' . $locale . '.content.$1', $path);
		}
		return Hash::get($data, $translationPath, Hash::get($data, $path));
	}

}
