<?php

App::uses('Component', 'Controller');

class TranslationComponent extends Component {

	protected $_controller = null;

	public function __construct(ComponentCollection $collection, $settings = []) {
		parent::__construct($collection, $settings);
		$this->settings = $settings;
	}

/**
 * Sets a reference to the calling controller from within the component.
 *
 * @see Component::initialize()
 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);
		$this->_controller = $controller;
	}

	public function adminTranslationFormFields() {
		$Model = $this->_controller->{$this->_controller->modelClass};
		$schema = $Model->schema();

		//debug($schema);

		$fields = [];
		foreach ($this->settings['fields'] as $key => $val) {
			if (is_numeric($key)) {
				if (!empty($schema[$val])) {
					$fields[$val] = $schema[$val];
				}
			} else {
				if (!empty($schema[$key])) {
					$fields[$key] = array_merge($schema[$key], $val);
				}
			}
		}

		$languages = Translation::getLocales(true);

		$data = [];
		foreach ($languages as $language) {
			$language = $language['lang'];
			foreach ($fields as $key => $value) {
				$data[$language][$Model->alias . '.__i18n.' . $language . '.content.' . $key] = $value;
				$data[$language][$Model->alias . '.__i18n.' . $language . '.id'] = array(
					'type' => 'integer'
				);
			}

			// Include menu fields for translation.
			if (!empty($this->settings['menu'])) {
				$data[$language]['Menu.__i18n.' . $language . '.id'] = array(
					'type' => 'integer'
				);
				$data[$language]['Menu.__i18n.' . $language . '.content.name'] = array(
					'type' => 'string',
					'label' => __('Menu'),
					'class' => 'menu-field'
				);
			}

			// Include meta data fields for translation.
			if (!empty($this->settings['meta'])) {
				$data[$language]['MetaData.__i18n.' . $language . '.id'] = array(
					'type' => 'integer'
				);
				$data[$language]['MetaData.__i18n.' . $language . '.content.title'] = array(
					'type' => 'string',
					'label' => __('Meta Title')
				);
				$data[$language]['MetaData.__i18n.' . $language . '.content.description'] = array(
					'type' => 'string',
					'label' => __('Meta Description')
				);
			}
		}

		$tabFields = [];
		if ($Model->hasBehaviour('EvCore.Tabbed') === true) {
			$tabs = $Model->getMaxTabs();
			foreach ($languages as $language) {
				$language = $language['lang'];
				for ($i = 0; $i < $tabs; $i++) {
					$tabFields[$language][] = array(
						'Tab.' . $i . '.__i18n.' . $language . '.id' => array(
							'type' => 'hidden'
						),
						'Tab.' . $i . '.__i18n.' . $language . '.content.title' => array(
							'type' => 'string'
						),
						'Tab.' . $i . '.__i18n.' . $language . '.content.content' => array(
							'type' => 'html'
						)
					);
				}
			}
		}

		$this->_controller->set('translationFields', $data);
		$this->_controller->set('translationTabFields', $tabFields);

		return;
	}

}
