<?php

App::uses('BuzzThemeAppModel', 'BuzzTheme.Model');

class Theme extends BuzzThemeAppModel {

/**
 * @var array Default theme ordering
 */
	public $order = array(
		'Theme.is_default' => 'DESC',
		'Theme.name' => 'ASC'
	);

/**
 * @var array Validation rules
 */
	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'validate.required'
			),
			'max' => array(
				'rule' => array('maxLength', 45),
				'message' => 'validate.maxLength45'
			)
		),
	);

/**
 * Before save logic
 *
 * @param array $options
 * @return bool
 */
	public function beforeSave($options = []) {
		if (parent::beforeSave($options) === true) {

			if (
				!empty($this->data[$this->alias]['id'])
				&& isset($this->data[$this->alias]['is_active'])
				&& (bool)$this->data[$this->alias]['is_active'] === false
			) {
				$this->id = $this->data[$this->alias]['id'];
				if ($this->field('is_default') === true) {
					$this->data[$this->alias]['is_active'] = true;
				}
			}

			return true;
		}

		return false;
	}

/**
 * Checks if the record is protected
 *
 * @param bool $cascade true if the delete is to cascade to children
 * @return bool true if the opperation was successful, otherwise false
 * @see Model::beforeDelete()
 */
	public function beforeDelete($cascade = true) {
		if ($this->hasField('is_default') && $this->field('is_default')) {
			return false;
		}
		return parent::beforeDelete($cascade);
	}

/**
 * Toggles a field on or off
 *
 * @param string $field field to toggle
 * @param integer $id ID of row
 * @return bool
 */
	public function toggleField($field, $id = null) {
		$this->id = empty($id) ? $this->id : $id;
		// Prevent the default row from being disabled.
		if ($field === 'is_active' && $this->field('is_default') === true) {
			return false;
		}
		return parent::toggleField($field, $id);
	}

}
