<?php

App::uses('BuzzThemeAppController', 'BuzzTheme.Controller');

class ThemesController extends BuzzThemeAppController {

/**
 * @return array
 */
	protected function _adminFormFields() {
		$Theme = $this->{$this->modelClass};
		$fields = parent::_adminFormFields();
		unset($fields[$Theme->alias . '.is_default']);
		return $fields;
	}

/**
 * @param int $id Theme ID
 * @return void
 */
	public function admin_edit($id = null) {
		parent::admin_edit($id);

		$Theme = $this->{$this->modelClass};

		// If we're editing the default theme hide the is_active flag.
		if ($id !== null && $this->request->data[$Theme->alias]['is_default'] === true) {
			unset($this->viewVars['fields'][$Theme->alias . '.is_active']);
		}

		return;
	}

}
