<?php

App::uses('CakeEventListener', 'Event');

class SubscriberListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Model.Subscriber.created' => 'subscribe'
		);
	}

	public function subscribe(CakeEvent $Event) {
		if (Configure::check('Mailchimp') === true) {
			// Add to queue for subscriber to MailChimp.
			ClassRegistry::init('Queue.QueuedTask')->createJob(
				'AddToMailChimp',
				['data' => $Event->data['id']]
			);
		}
		return;
	}

}
