<?php

App::uses('BuzzSubscribeAppController', 'BuzzSubscribe.Controller');

class SubscribersController extends BuzzSubscribeAppController {

/**
 * List of admin actions the controller supports
 * Used when you want to stop any administrator from performing an action
 * e.g. If you don't want an admin to delete something, override this in the controller and remove 'admin_delete'
 */
	public $adminActions = array(
		'admin_index',
		'admin_delete',
		'admin_view',
	);

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'subscribe'
		));
	}

	public function subscribe() {
		if (!empty($this->request->data)) {
			if ($this->Subscriber->save($this->request->data)) {
				$this->Session->setFlash(__d('buzz_subscribe', 'Thank you for subscribing'), 'flash_success');
				// Work out where to redirect to.
				$redirectUrl = $this->referer();
				$redirectUrl = $redirectUrl === Router::url($this->here, true) ? '/' : $redirectUrl;
				return $this->redirect($redirectUrl);
			} else {
				if (!isset($this->request->params['isAjax']) || !$this->request->params['isAjax']) {
					$this->Session->setFlash(__d('buzz_subscribe', 'Please correct the errors below.'), 'flash_fail');
				}
			}
		}

		$this->view = 'BuzzSubscribe./Subscribers/subscribe';

		return;
	}

	protected function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();
		$Subscriber = $this->{$this->modelClass};

		$newColumns = array(
			$Subscriber->alias . '.full_name' => array(
				'type' => 'string',
				'label' => __d('buzz_subscribe', 'Name')
			)
		);

		unset($columns[$Subscriber->alias . '.modified']);

		return ArrayUtil::addAfter($columns, $Subscriber->alias . '.id', $newColumns);
	}

	protected function _adminIndexColumnsWhitelist() {
		$Subscriber = $this->{$this->modelClass};

		$whitelist = parent::_adminIndexColumnsWhitelist();

		$whitelist[] = $Subscriber->alias . '.full_name';
		$whitelist[] = $Subscriber->alias . '.email';

		return $whitelist;
	}

/**
 * Filters
 *
 * @return array
 */
	protected function _adminFilterFields() {
		$filters = parent::_adminFilterFields();

		$Subscriber = $this->{$this->modelClass};

		unset($filters[$Subscriber->alias . '.name']);
		unset($filters[$Subscriber->alias . '.modified']);

		$newFilters = array(
			$Subscriber->alias . '.full_name' => array(
				'label' => __d('buzz_subscribe', 'Name'),
				'type' => 'string',
				'compare' => array('CONCAT(' . $Subscriber->alias . '.first_name, " ", IFNULL(' . $Subscriber->alias . '.last_name, \'\')) LIKE' => "%%%s%%")
			),
			$Subscriber->alias . '.email' => array(
				'label' => __d('buzz_subscribe', 'Email'),
				'type' => 'string',
				'compare' => array($Subscriber->alias . '.email LIKE' => "%%%s%%")
			)
		);

		return ArrayUtil::addAfter($filters, '$Subscriber->alias . .id', $newFilters);
	}

	protected function _adminIndexActions() {
		return array(
			'Delete',
			'Admin View'
		);
	}

	protected function _adminIndexToolbar() {
		return [];
	}

	protected function _adminFormToolbar($id = null) {
		$data = parent::_adminFormToolbar($id);
		unset($data['Add New']);
		return $data;
	}

}
