<?php
App::uses('QueueTask', 'Queue.Console/Command/Task');

class QueueAddToMailChimpTask extends QueueTask {

	public function add() {
	}

/**
 * Add a subscriber to MailChimp.
 *
 * @param array $data
 * @return bool Return true to complete queue task
 */
	public function run($data, $id = null) {
		$subscriber = ClassRegistry::init('BuzzSubscribe.Subscriber')->findById($data);

		$MailchimpSubscriber = ClassRegistry::init('Mailchimp.MailchimpSubscriber');

		$data = array(
			'fname' => $subscriber['Subscriber']['first_name'],
			'lname' => $subscriber['Subscriber']['last_name'],
			'email' => $subscriber['Subscriber']['email'],
			'source' => $subscriber['Subscriber']['source'] ?: 'website'
		);
		$options = array('doubleOptin' => true, 'updateExisting' => false);

		return $MailchimpSubscriber->subscribe($data, $options);
	}

}
