<?php

App::uses('BuzzSourceAppModel', 'BuzzSource.Model');

class StaffRotaApi extends BuzzSourceAppModel {

	/**
	 * Returns the data from the staff rota api.
	 * @param    string   $date         the date to filter by
	 * @param    string   $department   the department to filter by
	 * @param    string   $username     the username to filter by
	 * @return   array                  the array of records.
	 */
	public function getRotaRecords($date, $department = null, $username = null) {
		return $this->find('all', [
			'method' => 'GetRotaRecords',
			'conditions' => compact('date', 'department', 'username')
		]);
	}
}

