<?php

App::uses('BuzzStaffRotasAppModel', 'BuzzStaffRotas.Model');

class StaffRota extends BuzzStaffRotasAppModel {

	public $useTable = false;

	public $validate = [
		'Date' => [
			'required' => [
				'rule' => 'notEmpty',
				'message' => 'Please enter a date'
			],
			'isDate' => [
				'rule' => ['date', 'ymd'],
				'message' => 'Date is not in the correct format YYYY-MM-DD'
			]
		],
		'Department' => [
			'departmentIsSet' => [
				'rule' => ['departmentIsSet'],
				'message' => 'Please enter a department if entering a name'
			]
		]
	];

	public function departmentIsSet($check) {
		$department = trim($check['Department']);
		$username = trim($this->data['StaffRota']['Username']);
		if (!empty($username)) {
			// Username is not empty
			if (empty($department)) {
				// Username is not empty, but department is. This fails validation.
				return false;
			}
		}
		return true;
	}
}
