<?php

App::uses('BuzzStaffRotasAppController', 'BuzzStaffRotas.Controller');

class StaffRotasController extends BuzzStaffRotasAppController {

	public function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow(['index', 'rota']);
	}

	/**
	 * Index displays the form and handles the submitted response, building the
	 * url that the user is redirected to.
	 */
	public function index() {
		$Model = $this->{$this->modelClass};

		// If data has been submitted
		if (!empty($this->request->data)) {

			// Set response ready for validation.
			$filters = $this->request->data['StaffRota'];
			$Model->set($filters);

			if ($Model->validates()) {
				// Filters have validated!

				// In case they enter a valid datetime in the wrong form, for
				// example, 16-01-01, rather than 2016-01-01
				$date = date('Y-m-d', strtotime($filters['Date']));

				$department = (!empty($filters['Department'])) ? trim(strtolower($filters['Department'])) : '';
				$username = (!empty($filters['Username'])) ? trim(strtolower($filters['Username'])) : '';

				// Redirect to the rota page using these parameters.
				return $this->redirect(
					[
						'action' => 'rota',
						$date,
						$department,
						$username
					]
				);
			} else {
				// Filters do not validate.
				$this->Session->setFlash(
					__d('buzz_staff_rotas', 'Error submitting form: please see the errors below'),
					'flash_fail'
				);
			}
		}
	}

	public function rota($date, $department = null, $user = null) {
		$Model = $this->{$this->modelClass};
		$alias = $Model->alias;

		$this->loadModel('BuzzStaffRotas.StaffRotaApi');
		$records = $this->StaffRotaApi->getRotaRecords($date, $department, $user);
		if (!empty($records['StaffRotaApi']['d'])) {
			$data = $records['StaffRotaApi']['d'];

			// Order the array of objects based on name attribute of each object.
			usort($data, function ($a, $b) {
				return ($a['WorkedByUser'] > $b['WorkedByUser']);
			});
		} else {
			// Invalid parameters, API did not return data
			$data = [];
		}

		// Set the variables in the view in case they update the filters.
		$this->set(compact('data', 'date', 'department', 'user'));
	}

}
