<div style="margin:5px;">
	<h3><?=$title?></h3>
	<table class="table table--bordered">
		<thead>
			<th>Date</th>
			<th>Method</th>
			<th>Resource</th>
			<th>IP Address</th>
			<th>View</th>
		</thead>
		<tbody>
			<?php if (empty($data)): ?>
				<tr>
					<td colspan="5" style="text-align: center;">No records found.</td>
				</tr>
			<?php endif; ?>

			<?php foreach ($data as $item): ?>
				<tr>
					<td><?=$this->Time->format('F jS Y, h:i A', $item['ApiLog']['created'])?></td>
					<td><?=$item['ApiLog']['method']?></td>
					<td><?=$item['ApiLog']['model']?> (key: <?=$item['ApiLog']['foreign_id']?>)</td>
					<td><?=$item['ApiLog']['ip']?></td>
					<td>
						<?=$this->Html->link('<i class="s s--view"></i>',
							[
								'action' => 'view',
								$item['ApiLog']['id'],
							],
							['escape' => false]
						)?>
					</td>
				</tr>
			<?php endforeach; ?>
		</tbody>
	</table>
</div>
