<?php

App::uses('AppModel', 'Model');
App::uses('ConnectionManager', 'Model');
App::uses('Xml', 'Utility');

/**
 * BuzzSourceAppModel extended by API models from individual plugins.
 */
class BuzzSourceAppModel extends AppModel {

	public $useTable = false;

/**
 * The name of the DataSource connection that this Model uses (this is set in
 * the constructor so that we can use the app's config from bootstrap).
 *
 * @var string
 */
	public $useDbConfig = null;

	protected $_apiRequests = [];

	protected $_apiResponses = [];

	public function __construct($id = false, $table = null, $ds = null) {
		// Override the default host if we're using BuzzSites.
		if (CakePlugin::loaded('BuzzSites')) {
			$Site = ClassRegistry::init('BuzzSites.Site');
			ConnectionManager::create('api', $Site->getActiveSiteConfig());
			$this->useDbConfig = 'api';
		} else {
			die('Unable to find BuzzSites plugin. This is a requirement for all sites.');
		}

		$this->dataSource = ConnectionManager::getDataSource('api');

		parent::__construct($id, $table, $ds);
	}

	public function find($type = 'first', $query = []) {
		if (!empty($query['method'])) {
			$apiRequest = $query['method'];
			if (!empty($query['conditions'])) {
				$apiRequest = http_build_query($query['conditions']);
			}
			$this->_apiRequests[] = $apiRequest;
		}

		$results = parent::find($type, $query);
		if (!empty($query['method'])) {
			$this->_apiResponses[] = $results;
		}

		return $results;
	}

	public function post($type, $queryData = array(), $recursive = null) {
		$this->useDbConfig = 'SOAP' . Configure::read('api.default');
		$this->dataSource = ConnectionManager::getDataSource($this->useDbConfig);

		try {
			$result = $this->query($queryData['method'], array($queryData['conditions']));


			if (! empty($queryData['apiLog'])) {
				// Split out api log data
				$apiLog = $queryData['apiLog'];

				$ApiLog = ClassRegistry::init('BuzzSource.ApiLog');
				$ApiLog->add(
					$queryData['method'],
					'',
					array(),
					json_encode($result),
					$apiLog['model'],
					$apiLog['foreign_id']
				);
			}


			return $result;
		} catch (Exception $e) {
			CakeLog:: write('debug', $e->getMessage());
			return false;
		}
	}

/**
 * Returns a date in the European format to the SQL format.
 *
 * @param string $date European date format (e.g. 30/6/2015)
 * @return string SQL format date (e.g. 2015-06-30)
 */
	public static function dateToSqlFormat($date) {
		if (preg_match('|(\d{1,2})[/-](\d{1,2})[/-](\d{4})|', $date, $parts) === 1) {
			return $parts[3] . '-' . str_pad($parts[2], 2, '0', STR_PAD_LEFT) . '-' . str_pad($parts[1], 2, '0', STR_PAD_LEFT);
		}
		return null;
	}

/**
 * Returns a UNIX timestamp from a European date format.
 *
 * @param string $date European date format (e.g. 30/6/2015)
 * @return int Unix timestamp
 */
	public static function dateToTime($date) {
		if (preg_match('|(\d{1,2})[/-](\d{1,2})[/-](\d{4})( (\d{1,2}):(\d{1,2}))?|', $date, $parts) === 1) {

			$hour = 0;
			$mins = 0;
			if (!empty($parts[4])) {
				$hour = $parts[5];
				$mins = $parts[6];
			}

			return mktime($hour, $mins, 0, $parts[2], $parts[1], $parts[3]);
		}
		return null;
	}

/**
 * Takes a date provided by the API and attempts to re-format it into a consistent format that can
 * be used across the sites.
 * @param string $date Date
 * @return string Cleaned date
 */
	public function cleanApiDate($date) {
		$date = str_replace('/', '-', $date);
		if (preg_match('/\s\d{2}:\d{2}$/', $date)) {
			$date .= ':00';
		}

		return $date;
	}

	public function getApiResponses() {
		return array_combine($this->_apiRequests, $this->_apiResponses);
	}

}
