<?php
App::uses('AppModel', 'Model');

/**
 * ApiLog class.
 *
 * Extends AppModel rather than AppBuzzSourceAppModel as this uses the default
 * database config.
 */
class ApiLog extends AppModel {

	public $virtualFields = array(
	    'status' => '
			CASE WHEN (ApiLog.failed = \'0\') THEN
				\'Success\'
			ELSE
				\'Failed\'
			END
		'
	);

	/**
	 * Adds a new entry to the log.
	 *
	 * @param string $method
	 * @param string $requestUrl
	 * @param array $requestParams
	 * @param string $response
	 * @param string $model
	 * @param int $foreignId
	 * @return bool
	 */
	public function add($method, $requestUrl, $requestParams, $response, $model, $foreignId) {
		$data = [
			'method' => $method,
			'request' => $requestUrl . '?' . http_build_query($requestParams),
			'response' => $response,
			'model' => $model,
			'foreign_id' => $foreignId,
			'ip' => $_SERVER['REMOTE_ADDR'],
			'failed' => isset($response->ExceptionDetail)
		];
		$this->create(); // Ensure we create a new record
		return $this->save($data) !== false;
	}

	public function getEntries($model, $foreignId) {
		$conditions = [
			'ApiLog.model' => $model,
			'ApiLog.foreign_id' => $foreignId
		];
		$order = [
			'ApiLog.created' => 'ASC'
		];
		return $this->find('all', compact('conditions', 'order'));
	}

}
