<?php
App::uses('AppController', 'Controller');

class ApiLogsController extends AppController {

	/**
	 * Paginator defaults for admin.
	 *
	 * @var array
	 */
	public $adminPaginate = array(
		'sort' => 'created',
		'direction' => 'desc',
		'limit' => 25
	);

	public function beforeFilter() {
		parent::beforeFilter();

		if (CakeSession::read('Auth.User.UserGroup.id') != '1') {
			return $this->redirect('/admin');
		}
	}

	protected function _adminFilterFields() {
		$fields = parent::_adminFilterFields();

		unset($fields['ApiLog.id']);

		$fields['ApiLog.model'] = array(
			'label' => 'Model',
			'type' => 'string',
			'compare' => array(
				'ApiLog.model' => '%%%s%%'
			)
		);

		$fields['ApiLog.foreign_id'] = array(
			'label' => 'Model Id',
			'type' => 'string',
			'compare' => array(
				'ApiLog.foreign_id' => '%s'
			)
		);

		$fields['ApiLog.method'] = array(
			'label' => 'API Method',
			'type' => 'string',
			'compare' => array(
				'ApiLog.method' => '%%%s%%'
			)
		);
		$fields['ApiLog.failed'] = array(
			'label' => 'Failed?',
			'type' => 'boolean',
			'compare' => array(
				'ApiLog.failed' => '%s'
			)
		);

		return $fields;
	}

	protected function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();

		$extraColumns = array(
			'ApiLog.model' => array(
				'type' => 'string',
				'label' => 'Model'
			),
			'ApiLog.foreign_id' => array(
				'type' => 'integer',
				'label' => 'Model Id'
			),
			'ApiLog.method' => array(
				'type' => 'string',
				'label' => 'Method'
			),

			'ApiLog.status' => array(
				'type' => 'string',
				'label' => 'Status'
			),
		);

		return ArrayUtil::addAfter($columns, 'ApiLog.id', $extraColumns);
	}

	protected function _adminIndexActions() {
		return array(
			'Admin View'
		);
	}

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$foreignId = $this->request->data['ApiLog']['foreign_id'];
		$fields['ApiLog.foreign_id']['options'][$foreignId] = $foreignId;

		return $fields;
	}

	protected function _adminFormToolbar($id = null) {
		return array();
	}

	/**
	 * View data for this model
	 *
	 * @param integer $id ID of row to edit
	 * @return void
	 */
	public function admin_view($id) {
		parent::admin_view($id);

		// Find related / similar calls
		$related = $this->{$this->modelClass}->find('all', [
			'conditions' => [
				'request LIKE' => '%' . $this->data['ApiLog']['request'] . '%',
				'id !=' => $this->data['ApiLog']['id']
			]
		]);

		// Find calls from the same ip
		$sameIp = $this->{$this->modelClass}->find('all', [
			'conditions' => [
				'ip' => $this->data['ApiLog']['ip'],
				'id !=' => $this->data['ApiLog']['id']
			]
		]);

		// Find calls for the same model and model id
		$sameModel = $this->{$this->modelClass}->find('all', [
			'conditions' => [
				'model' => $this->data['ApiLog']['model'],
				'foreign_id' => $this->data['ApiLog']['foreign_id'],
				'id !=' => $this->data['ApiLog']['id']
			]
		]);

		$this->set(compact('related', 'sameIp', 'sameModel'));
		$this->view = 'admin_view';
	}
}
