<?php
class BuzzSourceChangedColumnTypeForForeignId extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzSource_changed_column_type_for_foreign_id';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			// We need to change the column type for foreign_id to support UUIDs as well as integer
			// values.
			'alter_field' => array(
				'api_logs' => array(
					'foreign_id' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8'),
				),
			),
		),
		'down' => array(
			'alter_field' => array(
				'api_logs' => array(
					'foreign_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
