<?php

App::uses('BuzzSlidesAppModel', 'BuzzSlides.Model');

class Slide extends BuzzSlidesAppModel {

	public $displayField = 'title';

/**
 * Behaviors
 *
 * @var array
 */
	public $actsAs = array(
		'BuzzTranslate.Translatable'
	);

/**
 * Constructor
 *
 * @param bool|int|string|array $id Set this ID for this model on startup,
 * can also be an array of options, see above.
 * @param string $table Name of database table to use.
 * @param string $ds DataSource connection name.
 */
	public function __construct($id = false, $table = null, $ds = null) {
		if (Configure::read('BuzzSlides.has_image')) {
			$this->imageSlots = [
				'main' => [
					'fields' => false,
					'slots' => 1
				]
			];
		}
		parent::__construct($id, $table, $ds);
	}

/**
 * Get slides
 *
 * @return array Slides data
 */
	public function getSlides() {
		if (Configure::read('BuzzSlides.has_image')) {
			$contain = ['Image'];
		}
		$conditions = ['Slide.is_active' => true];
		$order = 'Slide.sequence ASC';
		return $this->find('all', compact('contain', 'conditions', 'order'));
	}

}
