<?php

App::uses('BuzzSitesAppController', 'BuzzSites.Controller');

class SitesController extends BuzzSitesAppController {

	public $components = array(
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'name'
			)
		)
	);

	/**
	 * List of admin actions the controller supports
	 * Used when you want to stop any administrator from performing an action
	 * e.g. If you don't want an admin to delete something, override this in the controller and remove 'admin_delete'
	 */
	public $adminActions = [
		'admin_index',
		'admin_edit'
	];

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['Site.api_site_id']['type'] = 'numeric';
		$fields['Site.production_gateway_credentials']['type'] = 'text_plain';
		$fields['Site.production_gateway_credentials']['after'] = ' This should contain a json array of the gateway auth details. Please use a <a href="https://jsonlint.com/" target="_blank" rel="nofollow noreferrer">json validator</a> before saving.';
		$fields['Site.staging_gateway_credentials']['type'] = 'text_plain';
		$fields['Site.staging_gateway_credentials']['after'] = ' This should contain a json array of the gateway auth details. Please use a <a href="https://jsonlint.com/" target="_blank" rel="nofollow noreferrer">json validator</a> before saving.';
		$fields['Site.latlon']['after'] = ' A Json array of the latitue and longitude. Please use a <a href="https://jsonlint.com/" target="_blank" rel="nofollow noreferrer">json validator</a> before saving.';

		return $fields;
	}

	public function admin_edit($id = null) {
		parent::admin_edit($id);
		$this->Translation->adminTranslationFormFields();

		return;
	}
}
