<?php
App::uses('SiteManager', 'BuzzSites.Lib');
App::uses('Component', 'Controller');

class SitesComponent extends Component {

	protected $_controller;

/**
 * Initialise component, called before the controllers beforeFilter method
 *
 * @param Controller $controller Controller
 * @return void
 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);
		$this->_controller = $controller;
		$this->loadSites();
		$this->_configureDefaultTransactions();
	}

/**
 * Load sites
 *
 * @return void
 */
	public function loadSites() {
		$this->_controller->loadModel('BuzzSites.Site');

		$sites = $this->_controller->Site->getAll();
		$sitesList = $this->_controller->Site->getList($sites);
		$defaultSite = $this->_controller->Site->getDefaultSite($sites);

		$this->_controller->sites = $sites;
		$this->_controller->sitesList = $sitesList;
		$this->_controller->defaultSite = $defaultSite;
	}

/**
 * Configure the transactions for the site. We use the default site for these settings. If these
 * haven't been set then we just fallback to the usual config settings.
 *
 * @return void
 */
	protected function _configureDefaultTransactions() {
		if (
			empty($this->_controller->defaultSite['Site']['production_gateway_credentials'])
			|| empty($this->_controller->defaultSite['Site']['staging_gateway_credentials'])
		) {
			return;
		}
		$gatewayName = Configure::read('Transactions.gateway');
		Configure::write('Transactions.' . $gatewayName, [
			'live' => json_decode($this->_controller->defaultSite['Site']['production_gateway_credentials'], true),
			'dev' => json_decode($this->_controller->defaultSite['Site']['staging_gateway_credentials'], true),
		]);
	}
}
