<?php
class AddedSitesTable extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'added_sites_table';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'sites' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'api_site_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'production_gateway_credentials' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'staging_gateway_credentials' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'production_api_url' => array('type' => 'string', 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'staging_api_url' => array('type' => 'string', 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'production_diary_api_url' => array('type' => 'string', 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'staging_diary_api_url' => array('type' => 'string', 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'production_image_api_url' => array('type' => 'string', 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'staging_image_api_url' => array('type' => 'string', 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'is_default' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
					'is_active' => array('type' => 'boolean', 'null' => false, 'default' => '1'),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB'),
				),
			),
		),
		'down' => array(
			'drop_table' => array(
				'sites'
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		$db = new DATABASE_CONFIG();
		$productionApi = (isset($db->api['host']) ? $db->api['host'] : null);
		$stagingApi = (isset($db->testApi['host']) ? $db->testApi['host'] : null);
		$productionDiaryApi = (isset($db->diaryApi['host']) ? $db->diaryApi['host'] : null);
		$stagingDiaryApi = (isset($db->testDiaryApi['host']) ? $db->testDiaryApi['host'] : null);
		$productionImageApi = (isset($db->imageApi['host']) ? $db->imageApi['host'] : null);
		$stagingImageApi = (isset($db->imageApi['host']) ? $db->imageApi['host'] : null);
		$productionGateway = null;
		$stagingGateway = null;

		$gatewayName = Configure::read('Transactions.gateway');
		if (! empty($gatewayName) && Configure::check('Transactions.' . $gatewayName)) {
			$gatewayData = Configure::read('Transactions.' . $gatewayName);

			if (isset($gatewayData['live']) && is_array($gatewayData['live'])) {
				$productionGateway = json_encode($gatewayData['live']);
			}

			if (isset($gatewayData['dev']) && is_array($gatewayData['dev'])) {
				$stagingGateway = json_encode($gatewayData['dev']);
			}
		}

		$Site = ClassRegistry::init('BuzzSites.Site');
		$site = $Site->save([
			'name' => 'Default',
			'api_site_id' => Configure::read('api.site_id'),
			'production_gateway_credentials' => $productionGateway,
			'staging_gateway_credentials' => $stagingGateway,
			'production_api_url' => $productionApi,
			'staging_api_url' => $stagingApi,
			'production_diary_api_url' => $productionDiaryApi,
			'staging_diary_api_url' => $stagingDiaryApi,
			'production_image_api_url' => $productionImageApi,
			'staging_image_api_url' => $stagingImageApi,
			'is_default' => 1,
			'is_active' => 1
		]);
		return true;
	}
}
