<?php
App::uses('InflectorExt', 'Lib');

class SettingsHelper extends AppHelper {

/**
 * Include other helpers - we need the translation helper for strings and buttons.
 * @var array
 */
	public $helpers = [
		'BuzzTranslate.I18n',
		'Html' => [
			'className' => 'HtmlExt'
		]
	];

/**
 * Check a site setting has been set.
 *
 * @param string $setting Site setting slug
 *
 * @return bool
 */
	public function check($setting) {
		$val = Configure::read('SiteSetting.' . $setting);
		return !empty($val);
	}

/**
 * Returns a site setting or the default value if the setting is not set.
 *
 * @param string $setting Site setting slug
 * @param string $defaultValue Default setting value
 *
 * @return string
 */
	public function get($setting, $defaultValue = null) {
		return Configure::read('SiteSetting.' . $setting) ?: $defaultValue;
	}

/**
 * Returns a translated CMS string.
 *
 * @param string $string String slug
 *
 * @return string
 */
	public function string($string) {
		return $this->I18n->translate(Configure::read('String.' . $string), 'value');
	}

/**
 * Returns a translated button/link.
 *
 * @param string $string String slug
 * @param array $options Link options
 *
 * @return string
 */
	public function button($string, $options = []) {
		$text = $this->I18n->translate(Configure::read('Button.' . $string), 'name');
		$url = $this->I18n->translate(Configure::read('Button.' . $string), 'url') ?: '#';

		return !empty($text) ? $this->Html->link($text, $url, $options) : null;
	}

}
