<?php

class SiteSetting extends SiteSettingsAppModel {

	public $order = array('SiteSetting.name' => 'ASC');

	public $belongsTo = array(
		'SiteSettingCategory'
	);

	public $findMethods = array('grouped' => true);

	protected function _findGrouped($state, $query, $results = array()) {
		if ($state == 'before') {
			$query['contain'][] = 'SiteSettingCategory';
			return $query;

		} else {
			$data = array();
			foreach ($results as $result) {
				$data[$result['SiteSettingCategory']['name']][] = $result;
			}
			$results = $data;

		}

		return $results;
	}

/**
 * After save
 *
 * @param bool $created
 * @param array $options
 * @return void
 */
	public function afterSave($created, $options = array()) {
		parent::afterSave($created, $options);
		// Clear the cache of settings.
		Cache::delete('all_settings');
		return;
	}

}
