<?php

App::uses('SiteSettingsAppModel', 'SiteSettings.Model');

class CmsString extends SiteSettingsAppModel {

/**
 * Custom database table name.
 *
 * @var string
 * @link http://book.cakephp.org/2.0/en/models/model-attributes.html#usetable
 */
	public $useTable = 'strings';

	public $displayName = 'String';

	public $displayField = 'label';

/**
 * Behaviours
 *
 * @var array
 */
	public $actsAs = array(
		'BuzzTranslate.Translatable'
	);

/**
 * After save
 *
 * @param bool $created
 * @param array $options
 * @return void
 */
	public function afterSave($created, $options = array()) {
		parent::afterSave($created, $options);
		// Clear the cache of strings.
		Cache::delete('all_strings');
		return;
	}

}
