<?php
App::uses('SiteSettingsAppModel', 'SiteSettings.Model');

class Button extends SiteSettingsAppModel {

/**
 * Behaviours
 *
 * @var array
 */
	public $actsAs = array(
		'BuzzTranslate.Translatable'
	);

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'max' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters'
			)
		),
		'url' => array(
			'required' => array(
				'rule' => 'validateUrls',
				'message' => 'Invalid URL'
			)
		),
	);

/**
 * Custom validation method for checking a URL (internal or external).
 *
 * @param array $data
 * @return bool
 */
	public function validateUrls(array $data) {
		$check = array_pop($data);

		$validates = preg_match('|^\/[\w\-_\/]+|', $check) === 1;
		if ($validates === false) {
			$validates = Validation::url($check);
		}

		return $validates;
	}

/**
 * After save
 *
 * @param bool $created
 * @param array $options
 * @return void
 */
	public function afterSave($created, $options = []) {
		parent::afterSave($created, $options);
		// Clear the cache of strings.
		Cache::delete('all_buttons');
		return;
	}

}
