<?php
App::uses('SiteSettingsAppController', 'SiteSettings.Controller');
/**
 * Handles requests for site settings
 */
class SiteSettingsController extends SiteSettingsAppController {

/**
 * Configure form fields
 *
 * @return array
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();
		$fields['SiteSetting.options']['type'] = 'text_plain';

		return $fields;
	}

	/**
	 * Defines the buttons displayed on the admin toolbar
	 */
	protected function _adminIndexToolbar() {
		$user = $this->Auth->user();
		if ($user['User']['user_group_id'] == 1) {

			return array(
				'Add New Setting' => array(
					'url' => array('action' => 'add')
				)
			);
		} else {

			return;
		}
	}

/**
 * Landing Page - Edit Site settings
 *
 * Site settings are handled differently from other models
 * This screen is a combined index & edit
 */
	public function admin_index() {
		$fields = array();

		$data = $this->SiteSetting->find('grouped', array(
			'order' => array(
				'SiteSettingCategory.sequence' => 'ASC',
				'SiteSetting.sequence' => 'ASC',
				'SiteSetting.name' => 'ASC'
			)
		));

		// Build up a field list to display the settings.
		foreach ($data as $categoryName => $category) {
			foreach ($category as $setting) {
				$fieldConfig = [
					'type' => trim($setting['SiteSetting']['type']),
					'label' => $setting['SiteSetting']['label'] ?: $setting['SiteSetting']['name'],
				];
				if ($fieldConfig['type'] === 'select') {
					$options = explode("\n", $setting['SiteSetting']['options']);
					$fieldConfig['options'] = array_combine($options, $options);
				}
				$fields[$categoryName]['SiteSetting.' . $setting['SiteSetting']['name']] = $fieldConfig;
			}
		}

		// handle a form post
		if (!empty($this->request->data)) {

			foreach ($this->request->data['SiteSetting'] as $fieldName => $value) {
				$siteSettingFields = array('value' => '"' . addslashes($value) . '"');
				$siteSettingConditions = array('SiteSetting.name' => $fieldName);
				$this->SiteSetting->updateAll($siteSettingFields, $siteSettingConditions);
			}

			// Clear the cache of settings.
			Cache::delete('all_settings');

			$this->set('settings_saved', true);
		} else {

			foreach ($data as $category) {

				foreach ($category as $setting) {

					$this->request->data['SiteSetting'][$setting['SiteSetting']['name']] = $setting['SiteSetting']['value'];
				}
			}
		}

		$this->set('fields', $fields);
		$this->set('toolbar', $this->_adminIndexToolbar());
		$this->set('title_for_layout', 'Site Settings');
		$this->render('admin_form');

		return;
	}

	protected function _adminPopulateLookups() {
		$siteSettingCategories = $this->SiteSetting->SiteSettingCategory->find('list');
		$this->set(compact('siteSettingCategories'));
	}

}
