<?php

App::uses('Component', 'Controller');

/**
 * Site Setting component
 *
 * Doesn't do much appart load any site settings from the SiteSetting table
 * and makes them available to Configure::read('SiteSetting.foo')
 *
 * @package CoreCMS/SiteSetting
 */
class SiteSettingsComponent extends Component {

/**
 * Create config entries for each site setting
 */
	public function initialize(Controller $controller) {
		$this->_controller = $controller;
		$this->_setSiteSettings();
		$this->_setStrings();
		$this->_setButtons();

		return parent::initialize($controller);
	}

/**
 * Configure app for site settings.
 * @return void
 */
	protected function _setSiteSettings() {
		$this->_controller->loadModel('SiteSettings.SiteSetting');
		// NB: Cache is cleared after saving settings.
		$settings = Cache::remember('all_settings', function () {
			return $this->_controller->SiteSetting->find('all');
		});
		foreach ($settings as $setting) {
			Configure::write('SiteSetting.' . $setting['SiteSetting']['name'], $setting['SiteSetting']['value']);
		}
	}

/**
 * Configure app for CMS strings.
 * @return void
 */
	protected function _setStrings() {
		$this->_controller->loadModel('SiteSettings.CmsString');
		// NB: Cache is cleared after saving strings.
		$strings = Cache::remember('all_strings', function () {
			return $this->_controller->CmsString->find('all');
		});
		foreach ($strings as $string) {
			Configure::write('String.' . $string['CmsString']['name'], ['value' => $string['CmsString']['value'], '__i18n' => !empty($string['CmsString']['__i18n']) ? $string['CmsString']['__i18n'] : []]);
		}
	}

/**
 * Configure app for buttons/links.
 * @return void
 */
	protected function _setButtons() {
		$this->_controller->loadModel('SiteSettings.Button');
		// NB: Cache is cleared after saving buttons.
		$buttons = Cache::remember('all_buttons', function () {
			return $this->_controller->Button->find('all');
		});
		foreach ($buttons as $button) {
			Configure::write('Button.' . $button['Button']['system_name'], [
				'name' => $button['Button']['name'],
				'url' => $button['Button']['url'],
				'__i18n' => !empty($button['Button']['__i18n']) ? $button['Button']['__i18n'] : []
			]);
		}
	}

}
