<?php

class CmsStringsController extends AppController {

/**
 * Components
 *
 * @var array
 */
	public $components = array(
		'BuzzTranslate.Translation' => array(
			'fields' => array(
				'value'
			)
		)
	);

/**
 * List of admin actions the controller supports
 *
 * @var array
 */
	public $adminActions = array(
		'admin_index',
		'admin_edit'
	);

/**
 * Admin add/edit
 *
 * @param int $id
 * @return void
 */
	public function admin_edit($id = null) {
		$CmsString = $this->{$this->modelClass};

		parent::admin_edit($id);

		if ($id !== null) {

			$data = $this->request->data[$CmsString->alias];

			unset($this->viewVars['fields'][$CmsString->alias . '.name']);
			unset($this->viewVars['fields'][$CmsString->alias . '.label']);
			unset($this->viewVars['fields'][$CmsString->alias . '.enable_html']);

			$this->viewVars['fields'][$CmsString->alias . '.value']['type'] = $data['enable_html'] ? 'text' : 'text_plain';

			// Update 'value' label with translated label from record.
			$label = TranslateUtil::translate(
				$data,
				'label'
			);
			$this->viewVars['fields'][$CmsString->alias . '.value']['label'] = $label;

			$this->Translation->settings['fields']['value'] = ['label' => $label];

		} else {
			$this->viewVars['fields'][$CmsString->alias . '.value']['type'] = 'text_plain';
		}

		// Set the translation form fields and make sure we use the correct text editor.
		$this->Translation->adminTranslationFormFields();
		if ($id !== null && empty($data['enable_html'])) {
			foreach ($this->viewVars['translationFields'] as $lang => &$fields) {
				$fields['CmsString.__i18n.' . $lang . '.content.value']['type'] = 'text_plain';
			}
		}
		// If we're editing content we want to get the related help text for the button to display
		// to the user.
		if (!empty($id)) {
			$CmsString->id = $id;
			$help = $CmsString->field('help');
			$this->set(compact('help'));
		}
		$this->view = 'SiteSettings.../Scaffold/admin_form';

		return;
	}

	protected function _adminIndexActions() {
		return array(
			'Edit'
		);
	}

	protected function _adminIndexToolbar($id = null) {
		return [];
	}

	protected function _adminFormToolbar($id = null) {
		return [];
	}

}
