<?php
App::uses('SiteSettingsAppController', 'SiteSettings.Controller');

class ButtonsController extends AppController {

/**
 * Components
 *
 * @var array
 */
	public $components = [
		'BuzzTranslate.Translation' => [
			'fields' => [
				'name',
				'url' => [
					'label' => 'URL'
				]
			]
		]
	];

/**
 * List of admin actions the controller supports
 *
 * @var array
 */
	public $adminActions = array(
		'admin_index',
		'admin_edit'
	);

/**
 * Admin add/edit
 *
 * @param int $id
 * @return void
 */
	public function admin_edit($id = null) {
		// Only Administrators can add new buttons to the app.
		if ($this->Auth->user('UserGroup.id') > 1 && empty($id)) {
			throw new UnauthorizedException('You cannot add new buttons to the site');
		}
		parent::admin_edit($id);
		// Set the translation form fields and make sure we use the correct text editor.
		$this->Translation->adminTranslationFormFields();
		// If we're editing content we want to get the related help text for the button to display
		// to the user.
		if (!empty($id)) {
			$this->Button->id = $id;
			$help = $this->Button->field('help');
			$this->set(compact('help'));
		}

		$this->view = 'SiteSettings.../Scaffold/admin_form';
	}

/**
 * Form fields
 * @return array Fields
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();
		$fields['Button.url']['label'] = 'URL';

		if ($this->Auth->user('UserGroup.id') > 1) {
			unset($fields['Button.system_name']);
			unset($fields['Button.help']);
		}

		return $fields;
	}

	protected function _adminIndexActions() {
		return array(
			'Edit'
		);
	}

	protected function _adminIndexToolbar($id = null) {
		return [];
	}

	protected function _adminFormToolbar($id = null) {
		return [];
	}

}
