<?php
App::uses('AppHelper', 'View/Helper');
App::uses('PurchaseTrait', 'BuzzPurchase.Lib/Traits');

class PurchaseHelper extends AppHelper {

	use PurchaseTrait;

/**
 * Helpers
 * @var array
 */
	public $helpers = ['Number'];

/**
 * Calculate the included tax in the passed amount
 * @param float $amount Amount including tax
 * @return string Tax including currency
 */
	public function tax($amount) {
		$tax = $this->calculateTax($amount, Configure::read('BuzzPurchase.taxPercent'));
		return $this->Number->currency($tax);
	}

}
