<?php if (!empty($ecommerceTracking) && Configure::read('BuzzPurchase.gtmEnhancedEcommerce') === true): ?>
	<?php
		$items = [];
		foreach ($ecommerceTracking['items'] as $trackingItem) {
			$items[] = [
				'id' => $trackingItem['sku'],
				'name' => $trackingItem['name'],
				'price' => $trackingItem['price'],
				'quantity' => $trackingItem['quantity'],
				'category' => $trackingItem['category'],
			];
		}

		$data = [
			'event' => 'eec.purchase',
			'ecommerce' => [
				'currencyCode' => $ecommerceTracking['currency'],
				'purchase' => [
					'actionField' => [
						'id' => $ecommerceTracking['salesRef'],
						'affiliation' => Configure::read('SiteSetting.site_title'),
						'revenue' => $ecommerceTracking['revenue'],
						'tax' => $ecommerceTracking['tax'],
						'shipping' => $ecommerceTracking['shipping'],
						'coupon' => $ecommerceTracking['discountCode'],
					],
					'products' => $items,
				]
			],
		];
	?>
	<script>
	if (cookie('gtm_enhanced_tracking_<?= $ecommerceTracking['salesRef'] ?>') != '1') {
		window.dataLayer = window.dataLayer || []
		dataLayer.push(<?= json_encode($data) ?>);

		cookie('gtm_enhanced_tracking_<?=$ecommerceTracking['salesRef']?>', '1', 86400000);
	}
	</script>
<?php endif; ?>
